/*
  screen/win shots
  written by alexander yaworsky
  '99
*/

#include <excpt.h>
#include <windows.h>

#include "crc.h"
#include "stdlib.h"
#include "stringlist.h"
#include "executive.h"
#include "errors.h"
#include "network.h"
#include "switches.h"


typedef int (FAR __export __syscall * PLUGINMAIN)( char* Src, char** Dst,
                                                   char* Params );
  // returns size of converted image


static int ConvertImage( STRINGLIST* Params, int StartIdx,
                         char* Src, char** Dst )
  {
    int          Rc = 0;
    char         *PluginParams;
    PLUGINMAIN   Entry;
    HMODULE      PHandle;

    Entry = LoadImgPlugin( Params, StartIdx, &PHandle, &PluginParams );
    if( Entry != NULL ) {
      _try {
        Rc = Entry( Src, Dst, PluginParams );
      }
      _except (EXCEPTION_EXECUTE_HANDLER) {
        Rc = 0;
      }
      FreeLibrary( PHandle );
      if( PluginParams != NULL ) LocalFree( PluginParams );
    }
    return Rc;
  }

static int SendScreenshot( void* Ctx, char* Data, long FSz )
  {
    SYSTEMTIME  Stm;
    char        Buf[ 16 ];
    char        *dp;
    int         i, j, Rc;
    long        Sent;
    ULONG       Crc32;

    GetLocalTime( &Stm );
    Buf[1] = (char) FSz;
    Buf[2] = (char) (FSz >> 8);
    Buf[3] = (char) (FSz >> 16);
    Buf[4] = (char) (FSz >> 24);
    Buf[5] = (char) Stm.wYear;
    Buf[6] = (char) (Stm.wYear >> 8);
    Buf[7] = (char) Stm.wMonth;
    Buf[8] = (char) Stm.wDay;
    Buf[9] = (char) Stm.wHour;
    Buf[10] = (char) Stm.wMinute;
    Buf[11] = (char) Stm.wSecond;
    Buf[12] = 0; // reserved
    Buf[13] = 0; // reserved
    Buf[14] = 0; // reserved
    Buf[15] = 0; // reserved
    Buf[0] = CalculateCrc8( Buf + 1, 15 ); // set CRC8 field
    if( ! SendData( Ctx, Buf, 16 ) ) return ERRNET2_SEND;
    CRC32_Init( Crc32 );
    Sent = 0;
    Rc = ERRNET2_OK;
    while( Sent < FSz ) {
      if( FSz - Sent < 512 ) i = FSz - Sent; else i = 512;
      dp = Data + Sent;
      if( ! SendData( Ctx, dp, i ) ) {
        Rc = ERRNET2_SEND;
        break;
      }
      for( j = 0; j < i; j++ ) CRC32_Upd( Crc32, dp[ j ] );
      Sent += i;
    }
    if( Rc == ERRNET2_OK ) {
      Buf[0] = (char) Crc32;
      Buf[1] = (char) (Crc32 >> 8);
      Buf[2] = (char) (Crc32 >> 16);
      Buf[3] = (char) (Crc32 >> 24);
      if( ! SendData( Ctx, Buf, 4 ) ) Rc = ERRNET2_SEND;
    }
    return Rc;
  }


static BOOL Shot( void* Ctx, STRINGLIST* Params, STRINGLIST* Result,
                  int StartIdx, HDC SrcDC, int w, int h )
  {
    HDC      Dc;
    HBITMAP  Bmp;
    BITMAPINFO  Bmi;
    BITMAPFILEHEADER Fhdr;
    int      rs;
    char     *Buf, *ConvertedImage = NULL;
    int      ImageSize;
    BOOL     Rc = FALSE;

    if( (Bmp = CreateCompatibleBitmap( SrcDC, w, h )) != NULL ) {
      if( (Dc = CreateCompatibleDC( SrcDC )) != NULL ) {
        if( SelectObject( Dc, Bmp) ) {
          if( BitBlt( Dc, 0, 0, w, h, SrcDC, 0, 0, SRCCOPY ) ) {
            rs = (w * 3 + 3) & ~3;
            if( (Buf = (char*) LocalAlloc( LPTR, rs * h +
                                       sizeof(BITMAPINFOHEADER) +
                                       sizeof(BITMAPFILEHEADER) )) != NULL ) {
              RtlZeroMemory( &Bmi.bmiHeader, sizeof(BITMAPINFOHEADER) );
              Bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
              Bmi.bmiHeader.biPlanes = 1;
              Bmi.bmiHeader.biBitCount = 24;
              Bmi.bmiHeader.biCompression = BI_RGB;
              Bmi.bmiHeader.biSizeImage = 0;
              Bmi.bmiHeader.biClrUsed = 0;
              Bmi.bmiHeader.biClrImportant = 0;
              Bmi.bmiHeader.biXPelsPerMeter = 0;
              Bmi.bmiHeader.biYPelsPerMeter = 0;
              Bmi.bmiHeader.biWidth = w;
              Bmi.bmiHeader.biHeight = h;
              if( GetDIBits( Dc, Bmp, 0, h, Buf + sizeof(BITMAPFILEHEADER) +
                             sizeof(BITMAPINFOHEADER), &Bmi, 0 ) != 0 ) {
                Fhdr.bfType = 0x4D42;
                Fhdr.bfSize = sizeof(BITMAPFILEHEADER) + 
                              sizeof(BITMAPINFOHEADER) + rs * h;
                Fhdr.bfReserved1 = 0;
                Fhdr.bfReserved2 = 0;
                Fhdr.bfOffBits = sizeof(BITMAPFILEHEADER) + 
                                 sizeof(BITMAPINFOHEADER);
                CopyMemory( Buf, &Fhdr, sizeof(BITMAPFILEHEADER) );
                CopyMemory( Buf + sizeof(BITMAPFILEHEADER), &Bmi,
                            sizeof(BITMAPINFOHEADER) );
                ImageSize = ConvertImage( Params, StartIdx,
                                          Buf, &ConvertedImage );
                SetReply( Result, ERR_NO_ERROR, "" );
                SendStringList( Ctx, Result );
                if( ImageSize == 0  )
                  SendScreenshot( Ctx, Buf, Fhdr.bfSize );
                else
                  SendScreenshot( Ctx, ConvertedImage, ImageSize );
                if( ConvertedImage != NULL ) LocalFree( ConvertedImage );
                Rc = TRUE;
              }
              LocalFree( Buf );
            }
          }
        }
        DeleteObject( Bmp );
      }
      DeleteDC( Dc );
    }
    return Rc;
  }


FUNCDEF( Screenshot )
  {
    HDC      SrcDC;

    if( (SrcDC = CreateDC( "DISPLAY", NULL, NULL, NULL )) == NULL ) {
      SetReply( Result, ERR_API_ERROR, "CreateDC" );
      return 1;
    }
    if( ! Shot( Ctx, Params, Result, 1, SrcDC,
                GetDeviceCaps( SrcDC, HORZRES ),
                GetDeviceCaps( SrcDC, VERTRES ) ) ) {
      SetReply( Result, ERR_SHOT_ERROR, "" );
      DeleteDC( SrcDC );
      return 1;
    }
    DeleteDC( SrcDC );
    return 0;
  }


FUNCDEF( Winshot )
  {
    HDC      SrcDC;
    HWND     WinH;
    RECT     Wr;
    int      Rc;

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<window handle or 0>" );
      return 1;
    }
    WinH = (HWND) Strtoul( Params->Value[1], NULL, 16 );
    if( WinH == NULL ) WinH = GetForegroundWindow();
    if( (SrcDC = GetWindowDC( WinH )) == NULL ) {
      SetReply( Result, ERR_API_ERROR, "GetWindowDC" );
      return 1;
    }
    Rc = 1;
    if( ! GetWindowRect( WinH, &Wr ) )
      SetReply( Result, ERR_API_ERROR, "GetWindowRect" );
    else if( ! Shot( Ctx, Params, Result, 2, SrcDC,
                     Wr.right - Wr.left, Wr.bottom - Wr.top ) )
      SetReply( Result, ERR_SHOT_ERROR, "" );
    else
      Rc = 0;
    ReleaseDC( WinH, SrcDC );
    return Rc;
  }
